# -*- coding: utf-8 -*- 
# http://scipy-lectures.github.com


#---------------------------------------------------
#Import důležitých součástí
#---------------------------------------------------
import numpy as np
import scipy as sp
import pylab as plt
from scipy import signal
import matplotlib as mat
from scipy import io as soubory

import SumNaPozadi_functions as SnP
import Bunka_functions as Bunka
import Hmotnost_functions as Hmot

#---------------------------------------------------------------------------
#Vliv šumu na bunku
#---------------------------------------------------------------------------
SilaSumu = 0.3

#---------------------------------------------------------------------------
# čas cyklu při 121 opakování: 3:39
#---------------------------------------------------------------------------
for i in range(0, 121, 1):
    ObrazBunky = Bunka.BunkaVCase(Cas=i)         # Volání funkce na tvorbu bunky v různých časech
    Maska = Hmot.TvorbaMasky(ObrazBunky)         # Zjištění přesné polohy bunky - pomocí masky
    NasCas = i/120.0                              # Výpočet vhodné velikosti kroku změny v šumu
    ObrazSumu = SnP.SumVCase(Cas=NasCas)         # Volání funkce na tvorbu šumu v ruznych casech
    ZasumenaBunka = ObrazSumu*SilaSumu + ObrazBunky         # Vytvoření bunky na zasumenem pozadi
    Hmotnost2 = Hmot.HmotnostBunky(ZasumenaBunka,Maska)     # Výpočet hmotnosti bunky na zašuměném prostředí
    print Hmotnost2             # výpis spočítané hmotnosti zašuměné bunky
    fig = plt.figure(1)         # Vytváření figure
    fig.clear()                 # Uvolnění paměti - ochrana proti jejímu přesicení                  
    pl = fig.add_subplot(111)   # Vytváření subplotů
    img = pl.imshow(ZasumenaBunka, cmap=mat.cm.gray, origin='lower', vmin=0, vmax=1.0)      # Tvorba obrázku
    cbar = fig.colorbar(img)
    cbar.set_label('Hmotnost')                                                     # Vykreslení colorbaru
    plt.xlabel('x [px]')
    plt.ylabel('y [px]')                                                     # Vykreslení colorbaru
    fig.savefig("01-ZasumenaBunka/obr_%03d.png" % i)                       # Ukládání obrázků    
    soubory.savemat("01-ZasumenaBunka/ZasumenaBunka_%03d.mat" % i, {'ZasumenaBunka': ZasumenaBunka})  # Ukládání buněk
    soubory.savemat("01-ZasumenaBunka/Maska_%03d.mat" % i, {'Maska': Maska})                          # Ukládání masek
